\c demo_tsearch postgres
\set ON_ERROR_STOP on

/*******************************************************************/
-- UNDERSTANDING QUERIES


\H \o '03_ex1.html'
-- comparing a document with its text search equivalent
\qecho 'select content,tsearch from book_time_machine order by random() limit 3'
select content,tsearch from book_time_machine order by random() limit 3;

-- EX: deconstructing words
\o '03_ex2.html'
\qecho 'select distinct * from ts_debug(\'And here I must admit that I learned very little of drains and\') order by alias, description, token'
select distinct * from ts_debug('And here I must admit that I learned very little of drains and')
  order by alias, description, token;

-- EX: OR
\o '03_ex3.html'
\qecho 'select content from book_heart_darkness where tsearch @@ to_tsquery(\'darkness | evil\');'
select content from book_heart_darkness
  where tsearch @@ to_tsquery('darkness | evil');

-- EX: HEADLINES
\H \o '03_ex4.html'
\qecho 'select ts_headline(content, to_tsquery('darkness | evil'), \'MaxWords=35, MinWords=15\') from book_heart_darkness'
select ts_headline(content, to_tsquery('darkness | evil'), 'MaxWords=35, MinWords=15')
  from book_heart_darkness;

-- EX: AND (notice the words 'dark & darkness returns the same results')
\H \o '03_ex5.html'
\qecho 'select content from book_heart_darkness where tsearch @@ to_tsquery(\'dark & evil\')'
select content from book_heart_darkness
  where tsearch @@ to_tsquery('dark & evil');

\qecho 'select content from book_heart_darkness where tsearch @@ to_tsquery(\'darkness & evil\')'
select content from book_heart_darkness
  where tsearch @@ to_tsquery('darkness & evil');
